if (window.location.href.includes('weeklysummary')) {
    let td = document.createElement("td");
    td.className = "cellCenter";
    td.innerHTML = "GPA<br>Weighted / Unweighted";
    let heading = document.querySelectorAll('tr[class="listheading"]')[0];
    let after = heading.querySelectorAll('td[class="cellCenter"]')[1];
    heading.insertBefore(td, after);
    var gpatotal = [];
    var untotal = [];

    function toGpa(per, type) {
        var grade = Math.round(per);
        var gpa;
        if (grade >= 97) {
            gpa = 4.3;
        } else if (grade >= 93 && grade < 97) {
            gpa = 4.0;
        } else if (grade >= 90 && grade < 93) {
            gpa = 3.7;
        } else if (grade >= 87 && grade < 90) {
            gpa = 3.3;
        } else if (grade >= 83 && grade < 87) {
            gpa = 3.0;
        } else if (grade >= 80 && grade < 83) {
            gpa = 2.7;
        } else if (grade >= 77 && grade < 80) {
            gpa = 2.3;
        } else if (grade >= 73 && grade < 77) {
            gpa = 2.0;
        } else if (grade >= 70 && grade < 73) {
            gpa = 1.7;
        } else if (grade >= 67 && grade < 70) {
            gpa = 1.3;
        } else if (grade >= 63 && grade < 67) {
            gpa = 1.0;
        } else if (grade >= 60 && grade < 63) {
            gpa = 0.7;
        } else if (grade < 60) {
            gpa = 0.0;
        }
        if (type == "cp") {
            return gpa.toFixed(1);
        } else if (type == "hon") {
            return (gpa + 0.5).toFixed(1);
        } else if (type == "ap") {
            return (gpa + 1.0).toFixed(1);
        } else {
            if (gpa == 4.3) gpa -= 0.3;
            return gpa.toFixed(1);
        }
    }
    var underline = document.querySelectorAll('div[style="text-decoration: underline"]');
    for (var i = 0; i < underline.length; i++) {
        var grade = Number(underline[i].innerText.slice(0, -1));
        var name = document.querySelectorAll('font[color="#0000ff"]')[i].innerText.toLowerCase();
        var type;
        var row;
        if (name.includes("honors")) {
            type = "hon";
        } else if (name.includes("ap ")) {
            type = "ap";
        } else {
            type = "cp";
        }
        if (i % 2 == 0) {
            row = document.querySelectorAll('tr[class="listrowodd"]')[i / 2];
        } else {
            row = document.querySelectorAll('tr[class="listroweven"]')[(i - 1) / 2];
        }
        var gpa = toGpa(grade, type);
        var ungpa = toGpa(grade);
        gpatotal.push(gpa);
        untotal.push(ungpa);
        let elem = document.createElement("td");
        elem.className = "cellCenter";
        elem.innerHTML = (gpa + " / " + ungpa);
        let elemafter = row.querySelectorAll('td[class="cellCenter"]')[0];
        row.insertBefore(elem, elemafter);
    }
    if(gpatotal) {
        total = 0;
	for(var i = 0; i < gpatotal.length; i++) {
            total += gpatotal[i];
        }
        var avg = total / gpatotal.length;
        chrome.storage.local.set({'gpaavg': avg});
        total = 0;
        for(var i = 0; i < untotal.length; i++) {
            total += untotal[i];
        }
        var unavg = total / untotal.length;
        chrome.storage.local.set({'unavg': unavg});
    }
}